
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Jul 30 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version KMNG_ATP_TST_KeysOp_Data.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "KMNG_ATP_TST_ManageOp.h"
#include "KMNG_ATP_TST_KeysOp.h"
#include "CRYS_DH.h"


/************************ Defines *******************************/

/* canceling the lint warning:
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */

/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

/* DH data*/
CRYS_DHUserPubKey_t TST_DHUserPubKey;
CRYS_DHPrimeData_t  TST_DHPrimeData;

TST_KeysSym_TestDataStruct TST_KeysOpSym_TestData[] = 
{
  /* AES ECB/CBC/CTR/MAC 128/192/256 vectors*/
  {
    {"Imported 128AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xdd,0xd3,0x44,0x6f,0xf2,0x86,0x42,0xaa,0x3c,0xa7,0x64,0xbc,0xe7,0x48,0x06,0xb5},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 128AES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xdd,0xd3,0x44,0x6f,0xf2,0x86,0x42,0xaa,0x3c,0xa7,0x64,0xbc,0xe7,0x48,0x06,0xb5},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128AES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 128AES key MAC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_AESMode*/
    CRYS_AES_MAC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x6a,0x92,0x93,0x81,0x3b,0x57,0x02,0xc1,0xe2,0x65,0x3d,0x71,0x0f,0x18,0xd8,0x7f},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128AES key MAC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_MAC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 128AES key CTR"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xfc,0xbc,0x3d,0x7d,0x46,0x91,0x79,0xba,0x6a,0xb3,0xff,0xd1,0x6e,0x69,0x43,0x43},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128AES key CTR"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 128AES key wrap unwrap"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_WRAPPING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0xbf,0x58,0xa6,0x1e,0x7a,0x49,0xa7,0xdd,0x3f,0x3c,0x4e,0xad,0xc0,0x26,0x86,0x5d},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x10,0x2a,0xba,0x74,0x38,0xcf,0xea,0x6d,0x5f,0x1b,0x4d,0xb4,0xb1,0xa5,0xaa,0x1b,
     0x21,0x5f,0x9d,0x89,0x91,0x39,0x1c,0x11},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    24,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128AES key wrap unwrap"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_WRAPPING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    24,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  }, 
  {
    {"Imported 192AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
    0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xbd,0x33,0x4f,0x1d,0x6e,0x45,0xf2,0x5f,0xf7,0x12,0xa2,0x14,0x57,0x1f,0xa5,0xcc},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 192AES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
     0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
     /*TST_KeySize*/
     24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
    /*TST_AESMode*/
    CRYS_AES_CBC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x4f,0x02,0x1d,0xb2,0x43,0xbc,0x63,0x3d,0x71,0x78,0x18,0x3a,0x9f,0xa0,0x71,0xe8},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192AES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CBC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 192AES key MAC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x8e,0x73,0xb0,0xf7,0xda,0x0e,0x64,0x52,0xc8,0x10,0xf3,0x2b,0x80,0x90,0x79,0xe5,
     0x62,0xf8,0xea,0xd2,0x52,0x2c,0x6b,0x7b},
     /*TST_KeySize*/
     24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
    /*TST_AESMode*/
    CRYS_AES_MAC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x4f,0x02,0x1d,0xb2,0x43,0xbc,0x63,0x3d,0x71,0x78,0x18,0x3a,0x9f,0xa0,0x71,0xe8},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192AES key MAC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_MAC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 192AES key CTR"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x2c,0xb6,0x54,0x77,0x07,0x9c,0x80,0x9e,0xd1,0xc1,0xc6,0xec,0xc9,0x7c,0xf3,0x8c,
     0xb7,0x7d,0xc8,0xc6,0x1b,0x5e,0x45,0x2f},
     /*TST_KeySize*/
     24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x44,0x0e,0xb4,0x64,0x5d,0x89,0x2c,0x81,0xb8,0x9e,0xc0,0x8e,0x78,0xf0,0x55,0x6c},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x2f,0xd6,0xec,0x7c,0x86,0xa4,0x49,0x52,0x7b,0xa3,0xf7,0x87,0x5f,0xac,0xfb,0x59},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xbe,0x1a,0xfa,0xf6,0x71,0x01,0x7c,0x27,0x16,0x99,0x11,0x5a,0x47,0xcb,0x3e,0x18},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192AES key CTR"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x2f,0xd6,0xec,0x7c,0x86,0xa4,0x49,0x52,0x7b,0xa3,0xf7,0x87,0x5f,0xac,0xfb,0x59},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 192AES key wrap unwrap"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_WRAPPING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0xc6,0x01,0x6a,0x95,0xcf,0x1f,0xa7,0x52,0x7d,0xa9,0x8c,0x5d,0x71,0xce,0x58,0x86,
     0x8c,0xfb,0x98,0xba,0x56,0xab,0xa5,0x7a},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xfd,0xaf,0xff,0x84,0x5c,0x48,0x65,0x38,0x60,0xb1,0x9a,0x0b,0xc3,0x56,0x98,0x17,
     0x43,0xc8,0x89,0x8c,0xad,0x1b,0x5e,0x23},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    24,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192AES key wrap unwrap"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_WRAPPING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    24,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 256AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81, 
     0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
     /*TST_KeySize*/
     32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xf3,0xee,0xd1,0xbd,0xb5,0xd2,0xa0,0x3c,0x06,0x4b,0x5a,0x7e,0x3d,0xb1,0x81,0xf8},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 256AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 256AES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
     0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
     /*TST_KeySize*/
     32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
    /*TST_AESMode*/
    CRYS_AES_CBC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xf5,0x8c,0x4c,0x04,0xd6,0xe5,0xf1,0xba,0x77,0x9e,0xab,0xfb,0x5f,0x7b,0xfb,0xd6},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 256AES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CBC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 256AES key MAC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x60,0x3d,0xeb,0x10,0x15,0xca,0x71,0xbe,0x2b,0x73,0xae,0xf0,0x85,0x7d,0x77,0x81,
     0x1f,0x35,0x2c,0x07,0x3b,0x61,0x08,0xd7,0x2d,0x98,0x10,0xa3,0x09,0x14,0xdf,0xf4},
     /*TST_KeySize*/
     32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f},
    /*TST_AESMode*/
    CRYS_AES_MAC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
     0xae,0x2d,0x8a,0x57,0x1e,0x03,0xac,0x9c,0x9e,0xb7,0x6f,0xac,0x45,0xaf,0x8e,0x51,
     0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
     0xf6,0x9f,0x24,0x45,0xdf,0x4f,0x9b,0x17,0xad,0x2b,0x41,0x7b,0xe6,0x6c,0x37,0x10},
    /*TST_DataLen*/
    64,
    /*TST_ExpectedOutput*/
    {0xb2,0xeb,0x05,0xe2,0xc3,0x9b,0xe9,0xfc,0xda,0x6c,0x19,0x07,0x8c,0x6a,0x9d,0x1b},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 256AES key MAC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_MAC_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a,
     0xae,0x2d,0x8a,0x57,0x1e,0x03,0xac,0x9c,0x9e,0xb7,0x6f,0xac,0x45,0xaf,0x8e,0x51,
     0x30,0xc8,0x1c,0x46,0xa3,0x5c,0xe4,0x11,0xe5,0xfb,0xc1,0x19,0x1a,0x0a,0x52,0xef,
     0xf6,0x9f,0x24,0x45,0xdf,0x4f,0x9b,0x17,0xad,0x2b,0x41,0x7b,0xe6,0x6c,0x37,0x10},
    /*TST_DataLen*/
    64,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 256AES key CTR"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x33,0x58,0xdf,0xd9,0xf2,0x82,0x70,0x37,0xd8,0x04,0x84,0x69,0x3b,0x33,0x2f,0x00,
     0xf4,0xd1,0x3d,0x64,0x59,0x2e,0xc8,0x1b,0x6b,0x92,0x0a,0x48,0x50,0xdf,0x6f,0x72},
     /*TST_KeySize*/
     32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x78,0x12,0x25,0x78,0x51,0xfe,0x3c,0xe1,0x45,0xce,0x08,0x08,0x6b,0xcd,0xf8,0xb2},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xd8,0x37,0xca,0xae,0x1b,0xb5,0xb7,0xf4,0x62,0xd6,0xb1,0x28,0xa2,0xc9,0x01,0xff},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x82,0xe6,0x4f,0x67,0x9c,0x9f,0xb0,0x70,0x43,0xf8,0x2c,0x28,0x0c,0xcf,0x73,0x11},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 256AES key CTR"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xd8,0x37,0xca,0xae,0x1b,0xb5,0xb7,0xf4,0x62,0xd6,0xb1,0x28,0xa2,0xc9,0x01,0xff},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 256AES key wrap unwrap"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_WRAPPING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x87,0x8d,0x60,0xe6,0x46,0x83,0x22,0xee,0x7b,0x32,0x63,0x83,0xff,0x26,0x50,0xa6,
     0x18,0x94,0x14,0x68,0xe5,0x36,0x59,0x5c,0xfc,0x55,0x0c,0x4c,0x51,0x28,0x61,0x2b},
    /*TST_KeySize*/
    32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x02,0x87,0x75,0x9b,0xe4,0x33,0x91,0x61,0x4f,0xca,0xf7,0xa6,0x84,0x49,0xb7,0x42,
     0x83,0x0c,0x2b,0x34,0x80,0xd7,0x1b,0x23},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    24,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 256AES key wrap unwrap"},
      /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_WRAPPING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    32,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0xf7,0xe6,0xf3,0x72,0x74,0xa1,0x72,0x24,0x0b,0x0f,0xc9,0x7e,0x25,0x8b,0x37,0xce},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    24,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  /* DES Vectors 64Bits/128Bits/192Bits keys ECB/CBC mode */
  {
    {"Imported 64Bits DES key ECB"},
      /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x3d,0x26,0xb2,0xa7,0xa9,0xf3,0x55,0xde},
    /*TST_KeySize*/
    8,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x9e,0x86,0xde,0xe2,0x0c,0x42,0x67,0x05,0x78,0xcb,0xc7,0xf2,0x82,0xdd,0x50,0x2d},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 64Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    8,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 128Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x10,0x38,0xaa,0xc1,0xa2,0x3e,0x9e,0x13,0x60,0x28,0xb6,0x88,0x0f,0x33,0x8d,0x5c},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x48,0x20,0x56,0xd9,0x17,0xc0,0x2e,0x1d,0xc7,0x51,0x5e,0xa6,0x86,0xb7,0x15,0xd4},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 192Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0xe8,0x04,0xa7,0x88,0x73,0x37,0xcc,0x1c,0xf2,0x50,0x0c,0x04,0x86,0xf2,0x47,0x30,
     0xae,0xb8,0x7f,0x28,0x22,0x84,0xdf,0xfe},
     /*TST_KeySize*/
     24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xe5,0x08,0xb4,0x78,0x52,0x3d,0xa7,0xcf,0xb0,0x6a,0x9b,0xd8,0xf3,0x4b,0x9a,0x12},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 64Bits DES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x3d,0x26,0xb2,0xa7,0xa9,0xf3,0x55,0xde},
    /*TST_KeySize*/
    8,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x68,0xd1,0xed,0x01,0x3f,0x04,0x69,0x8c},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x1e,0xf4,0xd1,0x81,0x68,0x71,0xdd,0x77,0x79,0x38,0xa7,0xe0,0x12,0x54,0xc7,0x5b},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 64Bits DES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    8,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 128Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x10,0x38,0xaa,0xc1,0xa2,0x3e,0x9e,0x13,0x60,0x28,0xb6,0x88,0x0f,0x33,0x8d,0x5c},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x68,0xd1,0xed,0x01,0x3f,0x04,0x69,0x8c},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xc6,0xbe,0x66,0x03,0x44,0x64,0xbc,0x0f,0xb0,0x69,0x50,0xe3,0x9f,0xfe,0x08,0xbc},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 128Bits DES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 192Bits DES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0xe8,0x04,0xa7,0x88,0x73,0x37,0xcc,0x1c,0xf2,0x50,0x0c,0x04,0x86,0xf2,0x47,0x30,
     0xae,0xb8,0x7f,0x28,0x22,0x84,0xdf,0xfe},
     /*TST_KeySize*/
     24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0x68,0xd1,0xed,0x01,0x3f,0x04,0x69,0x8c},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xc2,0xb4,0xa6,0xaa,0xa6,0xa8,0xb5,0x4f,0xc0,0x9a,0xe4,0xdb,0x61,0xca,0x89,0x13},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 192Bits DES key CBC"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeDES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    24,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_CTR_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x6b,0xc1,0xbe,0xe2,0x2e,0x40,0x9f,0x96,0xe9,0x3d,0x7e,0x11,0x73,0x93,0x17,0x2a},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  /* HMAC vectors 160bits/224bits/256bits/384bits/512bits key with SHA1/SHA224/SHA256/SHA384/SHA512*/
  {
    {"Imported 160bHMAC key - SHA1"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x13,0x83,0x78,0x3f,0xaa,0x17,0xf4,0x60,0xc3,0x95,0x60,0xab,0x73,0x0f,0x95,0x65,
     0x7d,0x8c,0x8c,0x71},
     /*TST_KeySize*/
     20,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x3f,0x53,0xf0,0x3e,0xcd,0xf0,0x08,0x73,0xe6,0x9c,0x8b,0x91,0x8c,0xad,0x29,0xc3,
     0xa5,0x51,0xab,0x12},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    20,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 160bHMAC key - SHA1"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    20,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    20,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 224bHMAC key - SHA224"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0xa6,0x7d,0x26,0x51,0x4d,0x12,0x09,0xfe,0x83,0xf5,0x0c,0x2e,0x82,0x8c,0xce,0x9b,
     0x6b,0x81,0x1c,0x65,0x2d,0x18,0xff,0x07,0xa9,0xc0,0xf8,0x8a},
     /*TST_KeySize*/
     28,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA224_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x0b,0xea,0x22,0x06,0x21,0xd8,0x71,0xa5,0x29,0x38,0xc1,0x2c,0x41,0x32,0xce,0xb7,
     0x9e,0x1a,0x84,0x21,0x7d,0x82,0x38,0xc7,0x52,0xc9,0xe8,0x56},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    28,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 224bHMAC key - SHA224"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    28,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA224_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    28,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 256bHMAC key - SHA256"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x7f,0xf5,0x03,0xf5,0x7e,0xb6,0xc0,0xfc,0xee,0x17,0xcc,0x8f,0x4e,0xeb,0xba,0xc6,
     0xe9,0x9d,0x5d,0xf5,0x4f,0xce,0xde,0x76,0x05,0x3f,0x0b,0xa9,0x7c,0xf2,0xf2,0x38},
     /*TST_KeySize*/
     32,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA256_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xa0,0xcd,0x9e,0x99,0x06,0x72,0x19,0xd2,0x6e,0x73,0xbf,0x6e,0x71,0xa9,0x3a,0x01,
     0x77,0x5b,0xfc,0x82,0xad,0x24,0xee,0xc9,0xdc,0x7e,0x07,0xbd,0x42,0xb2,0x2a,0x68},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    32,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 256bHMAC key - SHA256"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    32,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA256_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    32,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 384bHMAC key - SHA384"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x40,0x0a,0xd7,0xde,0xb0,0xf5,0xa9,0xf7,0xff,0x7a,0xff,0x81,0xf9,0x0b,0x17,0x18,
     0xd6,0xc9,0x1e,0x83,0x56,0x47,0xe9,0x95,0x10,0x91,0xe5,0x50,0x06,0x6d,0x51,0x51,
     0x7e,0xe0,0xaa,0x68,0x0d,0xf4,0x67,0x86,0xf5,0xb9,0xe7,0xdc,0xb1,0x8a,0xa8,0x41},
     /*TST_KeySize*/
     48,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA384_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x8b,0x46,0x7b,0x15,0x62,0x3c,0x48,0xf3,0x1f,0x77,0x5d,0xea,0xa5,0x2e,0xb5,0xb9,
     0x43,0x7a,0xb0,0x3f,0x7a,0xf0,0xf8,0x44,0x13,0x69,0x06,0xb0,0x75,0x53,0x8e,0xaa,
     0xe7,0xc0,0xdd,0x05,0x3d,0x13,0xd9,0x90,0x97,0xd3,0x4c,0x0f,0x66,0x37,0xb5,0xe5},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    48,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 384bHMAC key - SHA384"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    48,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA384_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    48,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 512bHMAC key - SHA512"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x43,0xda,0x42,0xee,0xf1,0xc2,0xf7,0xd0,0x8b,0x76,0x91,0x1a,0xa0,0x9a,0x39,0x26,
     0xb6,0xef,0xbd,0x54,0x3b,0x74,0x2b,0x4e,0xbe,0xd2,0x9f,0x91,0x5f,0xf6,0x59,0x29,
     0x84,0x00,0x12,0xbb,0xce,0x5c,0x90,0xc9,0x4c,0x2e,0x79,0x32,0xee,0xf4,0x65,0xf8,
     0x3c,0x67,0x36,0x46,0x47,0xa1,0xac,0xb2,0xe0,0x85,0x34,0xbf,0x09,0x5c,0x01,0xa6},
     /*TST_KeySize*/
     64,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA512_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0x2f,0x91,0x21,0xad,0xdc,0x44,0x54,0x27,0xe9,0x49,0xcb,0x82,0x18,0x3c,0xa6,0x49,
     0x06,0x9f,0xa2,0x2f,0x80,0x44,0x3a,0x40,0xe8,0x8f,0x9c,0x82,0x25,0x96,0x4a,0x27,
     0xef,0xbe,0xe6,0x40,0x66,0x6d,0x02,0x2d,0xda,0xf9,0xb1,0x63,0xaa,0xd0,0x08,0xe2,
     0x3d,0x04,0x8d,0x7c,0x45,0xf8,0x49,0xde,0xc2,0x3e,0xa3,0xd2,0x79,0x7b,0x68,0xd7},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    64,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 512bHMAC key - SHA512"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    64,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_CBC_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA512_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputData*/
    {0},
    /*TST_OutputLen*/
    64,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  }
};


TST_KeysRSA_TestDataStruct TST_KeysOpRSA_TestData[] = 
{
  {
    {"Imported 1024RSA PKCS1v15 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xb7,0x33,0x08,0x1b,0x2d,0x70,0x31,0xd1,0xec,0x27,0x8b,0xb7,0x71,0x75,0x0e,0x63,
     0x97,0xef,0xd9,0x1f,0x36,0x49,0x36,0xb3,0x43,0xf4,0xbb,0x0a,0x9d,0x67,0xa8,0xc8,
     0x5a,0x1a,0x57,0xd5,0x5a,0x90,0x9e,0xed,0xad,0xc5,0x1d,0x0d,0x7a,0x66,0x30,0x61,
     0x6d,0xd2,0xef,0x6b,0xca,0xe2,0x21,0x09,0x9e,0xe4,0x2d,0xec,0x28,0x1e,0x27,0xbc,
     0xd3,0xf2,0xb3,0x01,0x44,0xc7,0x62,0x96,0xbe,0xf7,0x70,0x9e,0xdf,0xa3,0x02,0x3a,
     0x95,0x99,0x40,0x01,0x8c,0xf6,0xf6,0x88,0xe9,0xee,0x7d,0xea,0x51,0x1f,0x22,0xa5,
     0xd9,0xa7,0xfb,0x58,0x1d,0x77,0x21,0xc1,0x8e,0x0e,0xbc,0xd5,0xa0,0x87,0x99,0x36,
     0xcb,0x10,0xe8,0x08,0xf8,0x4d,0xd2,0xec,0xad,0x92,0x37,0x98,0x9a,0x32,0xdf,0x61},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0xb6,0xdb,0xba,0x20,0x9e,0x77,0x19,0x53,0x46,0x9b,0xa6,0x6a,0xc1,0x55,0xac,0xba,
     0x1e,0x22,0xea,0x9e,0xab,0xe9,0xe2,0x2e,0x87,0x0b,0x15,0x53,0x20,0x10,0x22,0xb9,
     0x70,0xae,0x50,0xb3,0x86,0x05,0x4a,0x8d,0x44,0xe0,0xb6,0x02,0x09,0x05,0x4d,0x0f,
     0x42,0xb6,0xc4,0x01,0xdc,0xed,0x5f,0x3a,0xa2,0x1d,0x71,0xf5,0x01,0x8a,0x2f,0xf0,
     0x2b,0x6f,0x33,0x2e,0x68,0xa6,0x40,0xb0,0x3f,0x66,0x7c,0xd0,0xe6,0x70,0x79,0x54,
     0x58,0x35,0x66,0x04,0x71,0xf8,0xc0,0x93,0x4b,0xe9,0x06,0x3b,0xf8,0xf2,0xe2,0x77,
     0x36,0xe0,0xfe,0x42,0x43,0x3c,0x3a,0x01,0x10,0xd2,0x6f,0xc1,0xb8,0x93,0x6e,0x03,
     0x60,0xaa,0x37,0x51,0x57,0x9a,0x8c,0xa8,0x9e,0x1b,0x10,0xab,0x43,0x88,0x83,0x51},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 1024RSA PKCS1v15 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0},
    /*TST_ESize*/
    0,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    0,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0},
    /*TST_DSize*/
    0,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 1024RSA PKCS1v21 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER21,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xb7,0x33,0x08,0x1b,0x2d,0x70,0x31,0xd1,0xec,0x27,0x8b,0xb7,0x71,0x75,0x0e,0x63,
     0x97,0xef,0xd9,0x1f,0x36,0x49,0x36,0xb3,0x43,0xf4,0xbb,0x0a,0x9d,0x67,0xa8,0xc8,
     0x5a,0x1a,0x57,0xd5,0x5a,0x90,0x9e,0xed,0xad,0xc5,0x1d,0x0d,0x7a,0x66,0x30,0x61,
     0x6d,0xd2,0xef,0x6b,0xca,0xe2,0x21,0x09,0x9e,0xe4,0x2d,0xec,0x28,0x1e,0x27,0xbc,
     0xd3,0xf2,0xb3,0x01,0x44,0xc7,0x62,0x96,0xbe,0xf7,0x70,0x9e,0xdf,0xa3,0x02,0x3a,
     0x95,0x99,0x40,0x01,0x8c,0xf6,0xf6,0x88,0xe9,0xee,0x7d,0xea,0x51,0x1f,0x22,0xa5,
     0xd9,0xa7,0xfb,0x58,0x1d,0x77,0x21,0xc1,0x8e,0x0e,0xbc,0xd5,0xa0,0x87,0x99,0x36,
     0xcb,0x10,0xe8,0x08,0xf8,0x4d,0xd2,0xec,0xad,0x92,0x37,0x98,0x9a,0x32,0xdf,0x61},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0xb6,0xdb,0xba,0x20,0x9e,0x77,0x19,0x53,0x46,0x9b,0xa6,0x6a,0xc1,0x55,0xac,0xba,
     0x1e,0x22,0xea,0x9e,0xab,0xe9,0xe2,0x2e,0x87,0x0b,0x15,0x53,0x20,0x10,0x22,0xb9,
     0x70,0xae,0x50,0xb3,0x86,0x05,0x4a,0x8d,0x44,0xe0,0xb6,0x02,0x09,0x05,0x4d,0x0f,
     0x42,0xb6,0xc4,0x01,0xdc,0xed,0x5f,0x3a,0xa2,0x1d,0x71,0xf5,0x01,0x8a,0x2f,0xf0,
     0x2b,0x6f,0x33,0x2e,0x68,0xa6,0x40,0xb0,0x3f,0x66,0x7c,0xd0,0xe6,0x70,0x79,0x54,
     0x58,0x35,0x66,0x04,0x71,0xf8,0xc0,0x93,0x4b,0xe9,0x06,0x3b,0xf8,0xf2,0xe2,0x77,
     0x36,0xe0,0xfe,0x42,0x43,0x3c,0x3a,0x01,0x10,0xd2,0x6f,0xc1,0xb8,0x93,0x6e,0x03,
     0x60,0xaa,0x37,0x51,0x57,0x9a,0x8c,0xa8,0x9e,0x1b,0x10,0xab,0x43,0x88,0x83,0x51},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 1024RSA PKCS1v21 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0},
    /*TST_ESize*/
    0,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    0,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0},
    /*TST_DSize*/
    0,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 2048RSA PKCS1v15 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    256,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xdc,0xdf,0xb1,0x56,0xe8,0xc1,0x1f,0x7d,0x2d,0x92,0xf7,0x33,0x58,0x24,0x7e,0xed,
     0x5c,0x93,0x02,0xf8,0xe3,0xf4,0x02,0x22,0xde,0xc7,0x48,0xe8,0x9d,0x99,0xc1,0xc3,
     0xfd,0xa0,0x3d,0x65,0x57,0xee,0xc0,0x91,0x90,0xe7,0x13,0x82,0x7a,0x10,0xba,0x70,
     0x98,0x49,0x57,0x01,0x17,0x5b,0x4d,0xa8,0xb9,0x23,0x48,0x5a,0x5a,0xbc,0xed,0x8b,
     0xa7,0xa1,0x29,0x36,0x43,0xde,0xc2,0x8d,0x96,0x4e,0x6a,0xa6,0x69,0x45,0x73,0xd3,
     0xa5,0xdd,0xb3,0x0d,0x0e,0xea,0x49,0x00,0x13,0x41,0xd7,0x3b,0x6e,0xb7,0xbc,0x01,
     0x39,0xc2,0x7f,0x7c,0xe3,0x00,0x23,0xa7,0x58,0x98,0x5e,0x40,0xda,0x7a,0xe4,0xa7,
     0x23,0xbd,0x6c,0xcf,0xc1,0xb2,0xf9,0xcf,0xb6,0x83,0xbe,0x66,0xde,0x6a,0x1f,0x61,
     0x44,0x00,0xc9,0xd1,0x1d,0xd9,0x6f,0x9f,0xf0,0x17,0x6b,0xcb,0x02,0xc8,0x3b,0xa5,
     0xf8,0x88,0x08,0xea,0xb3,0x8d,0xeb,0x8c,0x44,0x89,0x54,0xb1,0xce,0x35,0x71,0x35,
     0x2c,0xbc,0x47,0x2d,0xb7,0x2b,0x6c,0xed,0x4f,0x72,0x3b,0x4e,0x5c,0x9a,0xe5,0x3e,
     0xd8,0x46,0xf2,0x51,0xad,0x9b,0x31,0x94,0x1c,0xd8,0xd7,0x7b,0x5e,0x69,0xa6,0x25,
     0x87,0xbb,0xc2,0xb8,0x38,0x8a,0x57,0x5e,0xcc,0x89,0xa0,0xfb,0x86,0x44,0x86,0x24,
     0x01,0x82,0xf8,0xce,0xb9,0xa7,0x38,0xf0,0xde,0xb4,0xcd,0x32,0x74,0x43,0x94,0x81,
     0x95,0x15,0x77,0x3d,0x73,0xf7,0x34,0xa0,0xc6,0x0e,0xb0,0x72,0x91,0x50,0x2f,0x96,
     0xfc,0x3b,0x94,0xea,0xf4,0x89,0x6e,0x15,0xc7,0xb1,0x9f,0xea,0x93,0xac,0x57,0xe5},
    /*TST_NSize*/
    256,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0x26,0xf9,0x21,0xa5,0xa0,0x34,0x53,0x86,0x17,0x00,0x93,0xb5,0xef,0x9b,0xa0,0xf9,
     0xe9,0x17,0xd7,0xb2,0x6b,0x26,0xa7,0x29,0xd7,0xfd,0x7a,0x13,0xf1,0x9b,0x2b,0xe1,
     0x95,0x63,0x2c,0xf2,0x30,0xed,0xe3,0xf4,0xcb,0x88,0xba,0x9c,0x8f,0x45,0x5c,0x60,
     0x79,0xbe,0x97,0x27,0x8e,0x23,0x82,0x34,0x7f,0x56,0x86,0x71,0xcb,0x09,0x03,0x31,
     0x5d,0x46,0xc6,0xaa,0xd8,0x96,0xf9,0xe5,0x59,0xdc,0x44,0x5d,0x50,0xbd,0xfc,0x8e,
     0x1f,0xfa,0x5a,0x99,0xb7,0x44,0x07,0xd5,0x87,0x90,0x5a,0x96,0x16,0x17,0x3d,0x89,
     0x49,0xd3,0xd4,0x03,0x09,0x5b,0x00,0xef,0x8a,0x66,0x78,0x5b,0x21,0x32,0x06,0x1e,
     0xa7,0xe3,0xc8,0xcb,0x6f,0xf6,0x50,0xb6,0x22,0x12,0x65,0x0a,0x69,0xbc,0x78,0x04,
     0xb1,0xa2,0x64,0xd0,0xa1,0x04,0x96,0xc3,0x3e,0xfa,0xc3,0xcf,0xed,0x49,0xbe,0x21,
     0xcf,0xbc,0x31,0x3f,0x28,0x09,0x2e,0xad,0xd6,0x92,0xe1,0xfb,0xb6,0xbd,0x67,0x31,
     0x75,0x59,0x01,0x43,0x55,0x74,0x5b,0x6e,0x28,0xab,0x0b,0x08,0x47,0x97,0xc0,0xe3,
     0xa2,0x44,0x45,0x65,0x3d,0xab,0x40,0x46,0x9b,0x47,0xfe,0x46,0x22,0xa1,0x84,0x04,
     0xc6,0x79,0x84,0xc7,0xf3,0x25,0x60,0xae,0x95,0xaa,0x98,0x84,0xc6,0xc5,0xa7,0xde,
     0x7c,0x57,0x79,0x34,0x06,0x7e,0xd4,0x80,0x50,0x3d,0x98,0xd5,0x0c,0x06,0x73,0xd9,
     0xa0,0x25,0x60,0xbf,0x13,0x4e,0x59,0x9a,0x05,0xf8,0x24,0x7f,0xaf,0x29,0x9b,0xc4,
     0x8b,0x93,0x4c,0x44,0x2e,0xf1,0x21,0x3d,0x87,0xce,0xd6,0x3b,0x52,0xa0,0x92,0x11},
    /*TST_DSize*/
    256,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce,
     0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    256,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 2048RSA PKCS1v15 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    256,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0},
    /*TST_ESize*/
    0,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    0,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0},
    /*TST_DSize*/
    0,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce,
     0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    256,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 2048RSA PKCS1v21 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    256,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER21,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xdc,0xdf,0xb1,0x56,0xe8,0xc1,0x1f,0x7d,0x2d,0x92,0xf7,0x33,0x58,0x24,0x7e,0xed,
     0x5c,0x93,0x02,0xf8,0xe3,0xf4,0x02,0x22,0xde,0xc7,0x48,0xe8,0x9d,0x99,0xc1,0xc3,
     0xfd,0xa0,0x3d,0x65,0x57,0xee,0xc0,0x91,0x90,0xe7,0x13,0x82,0x7a,0x10,0xba,0x70,
     0x98,0x49,0x57,0x01,0x17,0x5b,0x4d,0xa8,0xb9,0x23,0x48,0x5a,0x5a,0xbc,0xed,0x8b,
     0xa7,0xa1,0x29,0x36,0x43,0xde,0xc2,0x8d,0x96,0x4e,0x6a,0xa6,0x69,0x45,0x73,0xd3,
     0xa5,0xdd,0xb3,0x0d,0x0e,0xea,0x49,0x00,0x13,0x41,0xd7,0x3b,0x6e,0xb7,0xbc,0x01,
     0x39,0xc2,0x7f,0x7c,0xe3,0x00,0x23,0xa7,0x58,0x98,0x5e,0x40,0xda,0x7a,0xe4,0xa7,
     0x23,0xbd,0x6c,0xcf,0xc1,0xb2,0xf9,0xcf,0xb6,0x83,0xbe,0x66,0xde,0x6a,0x1f,0x61,
     0x44,0x00,0xc9,0xd1,0x1d,0xd9,0x6f,0x9f,0xf0,0x17,0x6b,0xcb,0x02,0xc8,0x3b,0xa5,
     0xf8,0x88,0x08,0xea,0xb3,0x8d,0xeb,0x8c,0x44,0x89,0x54,0xb1,0xce,0x35,0x71,0x35,
     0x2c,0xbc,0x47,0x2d,0xb7,0x2b,0x6c,0xed,0x4f,0x72,0x3b,0x4e,0x5c,0x9a,0xe5,0x3e,
     0xd8,0x46,0xf2,0x51,0xad,0x9b,0x31,0x94,0x1c,0xd8,0xd7,0x7b,0x5e,0x69,0xa6,0x25,
     0x87,0xbb,0xc2,0xb8,0x38,0x8a,0x57,0x5e,0xcc,0x89,0xa0,0xfb,0x86,0x44,0x86,0x24,
     0x01,0x82,0xf8,0xce,0xb9,0xa7,0x38,0xf0,0xde,0xb4,0xcd,0x32,0x74,0x43,0x94,0x81,
     0x95,0x15,0x77,0x3d,0x73,0xf7,0x34,0xa0,0xc6,0x0e,0xb0,0x72,0x91,0x50,0x2f,0x96,
     0xfc,0x3b,0x94,0xea,0xf4,0x89,0x6e,0x15,0xc7,0xb1,0x9f,0xea,0x93,0xac,0x57,0xe5},
    /*TST_NSize*/
    256,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0x26,0xf9,0x21,0xa5,0xa0,0x34,0x53,0x86,0x17,0x00,0x93,0xb5,0xef,0x9b,0xa0,0xf9,
     0xe9,0x17,0xd7,0xb2,0x6b,0x26,0xa7,0x29,0xd7,0xfd,0x7a,0x13,0xf1,0x9b,0x2b,0xe1,
     0x95,0x63,0x2c,0xf2,0x30,0xed,0xe3,0xf4,0xcb,0x88,0xba,0x9c,0x8f,0x45,0x5c,0x60,
     0x79,0xbe,0x97,0x27,0x8e,0x23,0x82,0x34,0x7f,0x56,0x86,0x71,0xcb,0x09,0x03,0x31,
     0x5d,0x46,0xc6,0xaa,0xd8,0x96,0xf9,0xe5,0x59,0xdc,0x44,0x5d,0x50,0xbd,0xfc,0x8e,
     0x1f,0xfa,0x5a,0x99,0xb7,0x44,0x07,0xd5,0x87,0x90,0x5a,0x96,0x16,0x17,0x3d,0x89,
     0x49,0xd3,0xd4,0x03,0x09,0x5b,0x00,0xef,0x8a,0x66,0x78,0x5b,0x21,0x32,0x06,0x1e,
     0xa7,0xe3,0xc8,0xcb,0x6f,0xf6,0x50,0xb6,0x22,0x12,0x65,0x0a,0x69,0xbc,0x78,0x04,
     0xb1,0xa2,0x64,0xd0,0xa1,0x04,0x96,0xc3,0x3e,0xfa,0xc3,0xcf,0xed,0x49,0xbe,0x21,
     0xcf,0xbc,0x31,0x3f,0x28,0x09,0x2e,0xad,0xd6,0x92,0xe1,0xfb,0xb6,0xbd,0x67,0x31,
     0x75,0x59,0x01,0x43,0x55,0x74,0x5b,0x6e,0x28,0xab,0x0b,0x08,0x47,0x97,0xc0,0xe3,
     0xa2,0x44,0x45,0x65,0x3d,0xab,0x40,0x46,0x9b,0x47,0xfe,0x46,0x22,0xa1,0x84,0x04,
     0xc6,0x79,0x84,0xc7,0xf3,0x25,0x60,0xae,0x95,0xaa,0x98,0x84,0xc6,0xc5,0xa7,0xde,
     0x7c,0x57,0x79,0x34,0x06,0x7e,0xd4,0x80,0x50,0x3d,0x98,0xd5,0x0c,0x06,0x73,0xd9,
     0xa0,0x25,0x60,0xbf,0x13,0x4e,0x59,0x9a,0x05,0xf8,0x24,0x7f,0xaf,0x29,0x9b,0xc4,
     0x8b,0x93,0x4c,0x44,0x2e,0xf1,0x21,0x3d,0x87,0xce,0xd6,0x3b,0x52,0xa0,0x92,0x11},
    /*TST_DSize*/
    256,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce,
     0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    256,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Created 2048RSA PKCS1v21 key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    256,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER21,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0},
    /*TST_ESize*/
    0,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    0,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0},
    /*TST_DSize*/
    0,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce,
     0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    256,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"Imported 1024RSA PKCS1v15 key SHA-1"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xb4,0x2a,0x42,0x2d,0xc2,0xe9,0x62,0x74,0xc5,0xe6,0x82,0xf7,0x7b,0xd5,0x73,0x15,
     0xc5,0x8f,0x8a,0x41,0x55,0x88,0xf0,0x66,0xcb,0x7c,0x12,0x3c,0x03,0xe7,0x68,0x97,
     0xcd,0x57,0xe9,0xb4,0xf8,0x00,0xce,0x39,0x6f,0xdb,0x5e,0x60,0xed,0xff,0xba,0x85,
     0xb5,0x1f,0x84,0x2d,0x7c,0x43,0xf0,0x08,0xf9,0xd9,0x0c,0xe7,0x4f,0xb5,0xcd,0xe7,
     0x73,0xb0,0x78,0x8a,0xc5,0xd3,0x9a,0x02,0x64,0xac,0xc8,0x27,0xa5,0x12,0xfd,0xe6,
     0x4f,0x77,0x87,0x50,0xe7,0xa2,0xcc,0x82,0x87,0x90,0x08,0x32,0x8f,0xc4,0x76,0xbb,
     0x25,0x23,0x4a,0xd5,0x5c,0x20,0xd5,0x59,0x50,0xfa,0x5f,0x80,0xce,0x7f,0xf6,0xe6,
     0x65,0x39,0xe2,0x2f,0x16,0x9e,0x2f,0x7d,0xe1,0x2e,0xb5,0xda,0x60,0x12,0xe9,0x73},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0x7c,0x4f,0x48,0x18,0x51,0x0b,0x3d,0x3e,0xbb,0x29,0xc0,0xa5,0xc8,0x10,0xcf,0xf6,
     0x6e,0xb9,0x0a,0xb8,0xe7,0xae,0xb3,0xc9,0x09,0x8f,0xd2,0xf9,0x0b,0xec,0x88,0x53,
     0x6d,0x80,0xc2,0x25,0x76,0x94,0xff,0xb5,0xcb,0xc3,0x3d,0xcc,0x7d,0x8a,0xdc,0x84,
     0xd3,0x23,0x2a,0xcd,0x43,0x97,0x90,0xb0,0x70,0xcb,0xdd,0x46,0x60,0xce,0x5d,0x81,
     0xb3,0x75,0xd8,0x04,0x8a,0xb9,0x2e,0x46,0xd7,0xb0,0xc6,0x0a,0x2d,0xb5,0x3c,0xe0,
     0x1b,0xd1,0xd1,0xee,0x26,0x00,0x81,0xc4,0xe0,0x17,0xb1,0x12,0x5c,0xbe,0x9a,0x4a,
     0xa3,0x38,0x77,0x9a,0xc9,0xdf,0x24,0x73,0xb1,0xe1,0xfa,0x11,0xf2,0xb1,0x0b,0xc5,
     0x48,0xa1,0x8d,0xab,0xed,0x6a,0x92,0xfc,0xe0,0x07,0xfa,0xa6,0x01,0xfa,0xc0,0xb9},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
	  {"Created 1024RSA PKCS1v15 key SHA-1"},
		  /*TST_Pwd*/
	  {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	  /*TST_PwdLen*/
	  10,
	  /*TST_KeyPwd*/
	  {0x1,0x2,0x3,0x4},
	  /*TST_KeyPwdLen*/
	  4,
	  /*TST_KeyID*/
	  0,
	  /*TST_KeyType*/
	  KMNG_KeyTypeRSAPair,
	  /*TST_KeyUsage*/
	  KMNG_KEY_USAGE_SIGNING,
	  /*TST_KeyRestriction*/
	  KMNG_KEY_RESTRICTION_EXPORTABLE,
	  /*TST_KeySize*/
	  128,
	  /*TST_PKCS1_ver*/
	  CRYS_PKCS1_VER15,
	  /*TST_HASHMode*/
	  CRYS_RSA_HASH_SHA1_mode,
	  /*TST_E*/
	  {0x01,0x00,0x01},
	  /*TST_ESize*/
	  3,
	  /*TST_ExportedE*/
	  {0},
	  /*TST_ExportedESize*/
	  0,    
	  /*TST_N*/
	  {0},
	  /*TST_NSize*/
	  128,
	  /*TST_ExportedN*/
	  {0},
	  /*TST_ExportedNSize*/
	  0,    
	  /*TST_D*/
	  {0},
	  /*TST_DSize*/
	  128,
	  /*TST_ExportedD*/
	  {0},
	  /*TST_ExportedDSize*/
	  0,
	  /*TST_Data*/
	  {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
	  0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
	  0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
	  0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
	  0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
	  0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
	  0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
	  0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
	  /*TST_DataLen*/
	  128,
	  /*TST_ExpectedOutput*/
	  {0},
	  /*TST_OutputLen*/
	  0,
	  TST_KMNG_DO_NOT_VERIFY_OUTPUT,
	  /*TST_UserData*/
	  {0}
  },
  {
	  {"Imported 1024RSA PRIM key"},
		  /*TST_Pwd*/
	  {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	  /*TST_PwdLen*/
	  10,
	  /*TST_KeyPwd*/
	  {0x1,0x2,0x3,0x4},
	  /*TST_KeyPwdLen*/
	  4,
	  /*TST_KeyID*/
	  0,
	  /*TST_KeyType*/
	  KMNG_KeyTypeRSAPair,
	  /*TST_KeyUsage*/
	  KMNG_KEY_USAGE_SIGNING,
	  /*TST_KeyRestriction*/
	  KMNG_KEY_RESTRICTION_EXPORTABLE,
	  /*TST_KeySize*/
	  128,
	  /*TST_PKCS1_ver*/
	  CRYS_PKCS1_versionLast,
	  /*TST_HASHMode*/
	  CRYS_RSA_HASH_SHA1_mode,
	  /*TST_E*/
	  {0x01,0x00,0x01},
	  /*TST_ESize*/
	  3,
	  /*TST_ExportedE*/
	  {0},
	  /*TST_ExportedESize*/
	  0,    
	  /*TST_N*/
	  {0xe6,0xf1,0x8f,0xaf,0x4d,0xb6,0x24,0xa6,0x94,0x71,0xfb,0xeb,0x01,0x56,0xb6,0xdb,
	   0xca,0xdf,0xf2,0x2a,0x6c,0xb9,0x6f,0xd8,0x70,0xf2,0x8e,0x44,0x32,0xb1,0x0c,0x1b,
	   0xee,0xa8,0xdc,0x03,0x33,0x72,0xe6,0xc0,0x83,0xa7,0x47,0x34,0x01,0x10,0x1e,0xa6,
	   0x1f,0x04,0xe6,0xb3,0x41,0xec,0x97,0x59,0xf2,0xf6,0xf7,0x7c,0x16,0xc5,0xdd,0x97,
	   0xf5,0xdb,0x6c,0x60,0xbd,0x53,0xbc,0xa9,0xbd,0xd7,0xae,0xbf,0x70,0xf3,0x38,0xf4,
	   0xb4,0x5a,0x25,0x9c,0xcf,0xf1,0x2f,0xaf,0xdb,0x5d,0x43,0x5a,0xeb,0x07,0x5d,0xa7,
	   0xd8,0x44,0xa1,0x50,0x2a,0x98,0xba,0xba,0x81,0xc1,0x61,0x87,0x09,0x3b,0x54,0x8c,
	   0x20,0xde,0xc3,0x62,0x64,0xcf,0xc0,0x3f,0xe7,0x97,0xa7,0x7d,0x65,0x8e,0x31,0xeb},
	  /*TST_NSize*/
	  128,
	  /*TST_ExportedN*/
	  {0},
	  /*TST_ExportedNSize*/
	  0,    
	  /*TST_D*/
	  {0x0e,0x85,0x98,0x0c,0x64,0xed,0x94,0x26,0x69,0x65,0x35,0x7b,0x14,0x8d,0x78,0x58,
	   0x1f,0xcc,0xaf,0x34,0x9d,0xbb,0x97,0x5d,0xdb,0xd4,0x54,0xbf,0xd3,0x14,0x30,0xf7,
	   0xbc,0xad,0x1f,0x90,0x8f,0xf6,0xa4,0xad,0xec,0x59,0x63,0x6f,0xd0,0xb5,0x4b,0xc8,
	   0x14,0x61,0x41,0x84,0x7a,0x1b,0xbf,0x74,0xa7,0x83,0x82,0x12,0x6a,0x78,0x2c,0xb3,
	   0xd7,0xe3,0x72,0xfd,0x8c,0x14,0x6b,0x8d,0x0c,0xa4,0x78,0x16,0x78,0x13,0x23,0xe6,
	   0x00,0xe7,0x29,0xc5,0xc9,0xe7,0xa7,0x88,0x4d,0x9a,0x35,0x16,0xf9,0xb8,0x10,0x76,
	   0xdf,0x9b,0xbb,0x1d,0x3e,0xdf,0x80,0x67,0xf1,0x0f,0xe7,0xc7,0x2a,0x14,0x70,0x30,
	   0x09,0xd0,0x38,0xd3,0x95,0xe7,0x2f,0x37,0x76,0x78,0xc1,0xf9,0xaf,0x1a,0x81,0xa1},
	  /*TST_DSize*/
	  128,
	  /*TST_ExportedD*/
	  {0},
	  /*TST_ExportedDSize*/
	  0,
	  /*TST_Data*/
	  {0x98,0x62,0xed,0xc7,0x71,0x65,0x13,0xfb,0x51,0x62,0x3e,0xa5,0xfd,0xee,0xe3,0x8f,
	   0x68,0x89,0xc7,0x74,0xed,0x81,0xce,0x57,0x8f,0x12,0xe1,0x08,0x84,0xdf,0x5e,0x44,
	   0x69,0xba,0x6b,0x1a,0x3d,0x5c,0xe6,0x3e,0x82,0x51,0xd1,0x9f,0x07,0x74,0x48,0x20,
	   0x4b,0x2b,0x4e,0x78,0x07,0x90,0xdd,0xfc,0x47,0x6b,0x99,0xe0,0xbb,0x94,0xd7,0x45,
	   0x7f,0xb7,0xe3,0xca,0x94,0xb8,0x8e,0x7b,0x89,0x62,0xba,0x10,0x7d,0x7b,0x6d,0xb9,
	   0x74,0x92,0xfa,0xcd,0xb4,0x26,0x22,0x91,0x74,0x41,0xe0,0xff,0xe3,0x63,0xe2,0x12,
	   0xe4,0x2f,0x78,0x6a,0xb2,0x45,0x18,0x1e,0x81,0x58,0x07,0xc7,0x94,0xef,0x30,0x19,
	   0x4c,0x1f,0x0c,0x44,0x45,0x83,0x43,0x4b,0xe2,0xce,0x0d,0xe4,0x71,0xe5,0x56,0x9d},
	  /*TST_DataLen*/
	  128,
	  /*TST_ExpectedOutput*/
	  {0x65,0x8f,0xdc,0xcc,0x47,0x1f,0x35,0x16,0xa0,0xd8,0xde,0x08,0xc1,0x02,0xd7,0x7d,
	   0x90,0x24,0x3f,0xb2,0x28,0xff,0x80,0xa9,0x46,0xc0,0xc4,0x3f,0x79,0x28,0x3c,0x6c,
	   0x21,0x8f,0xa7,0xbf,0x90,0x14,0x68,0xc6,0x9a,0xfb,0x54,0x78,0x5d,0xab,0x4b,0x6e,
	   0x0b,0x35,0x24,0x89,0x55,0x9e,0x93,0x44,0x23,0x06,0xd8,0xd5,0x19,0xf2,0x0b,0x97,
	   0xf4,0x86,0x8e,0x7b,0x28,0x33,0x33,0x56,0x58,0x19,0xee,0xa5,0x75,0x17,0x22,0x2c,
	   0x50,0xad,0xd5,0x8b,0xa0,0x42,0xea,0x98,0x96,0xc0,0x01,0x0e,0xa5,0xdf,0x67,0x41,
	   0x9a,0x10,0x71,0x1b,0xd4,0xeb,0x4d,0xeb,0xe9,0xce,0xbe,0xc3,0x1e,0x35,0xcc,0x6e,
	   0x58,0xd9,0x3b,0xe3,0x52,0x88,0xbb,0x0e,0x04,0x02,0xbd,0x7c,0xfe,0xa5,0x6f,0xf5},
	  /*TST_OutputLen*/
	  128,
	  TST_KMNG_VERIFY_OUTPUT,
	  /*TST_UserData*/
	  {0}
  },
  {
	  {"Created 1024RSA PRIM key"},
	  /*TST_Pwd*/
	  {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	  /*TST_PwdLen*/
	  10,
	  /*TST_KeyPwd*/
	  {0x1,0x2,0x3,0x4},
	  /*TST_KeyPwdLen*/
	  4,
	  /*TST_KeyID*/
	  0,
	  /*TST_KeyType*/
	  KMNG_KeyTypeRSAPair,
	  /*TST_KeyUsage*/
	  KMNG_KEY_USAGE_SIGNING,
	  /*TST_KeyRestriction*/
	  KMNG_KEY_RESTRICTION_EXPORTABLE,
	  /*TST_KeySize*/
	  128,
	  /*TST_PKCS1_ver*/
	  CRYS_PKCS1_versionLast,
	  /*TST_HASHMode*/
	  CRYS_RSA_HASH_SHA1_mode,
	  /*TST_E*/
	  {0x01,0x00,0x01},
	  /*TST_ESize*/
	  3,
	  /*TST_ExportedE*/
	  {0},
	  /*TST_ExportedESize*/
	  0,    
	  /*TST_N*/
	  {0},
	  /*TST_NSize*/
	  0,
	  /*TST_ExportedN*/
	  {0},
	  /*TST_ExportedNSize*/
	  0,    
	  /*TST_D*/
	  {0},
	  /*TST_DSize*/
	  0,
	  /*TST_ExportedD*/
	  {0},
	  /*TST_ExportedDSize*/
	  0,
	  /*TST_Data*/
	  {0x98,0x62,0xed,0xc7,0x71,0x65,0x13,0xfb,0x51,0x62,0x3e,0xa5,0xfd,0xee,0xe3,0x8f,
	  0x68,0x89,0xc7,0x74,0xed,0x81,0xce,0x57,0x8f,0x12,0xe1,0x08,0x84,0xdf,0x5e,0x44,
	  0x69,0xba,0x6b,0x1a,0x3d,0x5c,0xe6,0x3e,0x82,0x51,0xd1,0x9f,0x07,0x74,0x48,0x20,
	  0x4b,0x2b,0x4e,0x78,0x07,0x90,0xdd,0xfc,0x47,0x6b,0x99,0xe0,0xbb,0x94,0xd7,0x45,
	  0x7f,0xb7,0xe3,0xca,0x94,0xb8,0x8e,0x7b,0x89,0x62,0xba,0x10,0x7d,0x7b,0x6d,0xb9,
	  0x74,0x92,0xfa,0xcd,0xb4,0x26,0x22,0x91,0x74,0x41,0xe0,0xff,0xe3,0x63,0xe2,0x12,
	  0xe4,0x2f,0x78,0x6a,0xb2,0x45,0x18,0x1e,0x81,0x58,0x07,0xc7,0x94,0xef,0x30,0x19,
	  0x4c,0x1f,0x0c,0x44,0x45,0x83,0x43,0x4b,0xe2,0xce,0x0d,0xe4,0x71,0xe5,0x56,0x9d},
	  /*TST_DataLen*/
	  128,
	  /*TST_ExpectedOutput*/
	  {0x65,0x8f,0xdc,0xcc,0x47,0x1f,0x35,0x16,0xa0,0xd8,0xde,0x08,0xc1,0x02,0xd7,0x7d,
	  0x90,0x24,0x3f,0xb2,0x28,0xff,0x80,0xa9,0x46,0xc0,0xc4,0x3f,0x79,0x28,0x3c,0x6c,
	  0x21,0x8f,0xa7,0xbf,0x90,0x14,0x68,0xc6,0x9a,0xfb,0x54,0x78,0x5d,0xab,0x4b,0x6e,
	  0x0b,0x35,0x24,0x89,0x55,0x9e,0x93,0x44,0x23,0x06,0xd8,0xd5,0x19,0xf2,0x0b,0x97,
	  0xf4,0x86,0x8e,0x7b,0x28,0x33,0x33,0x56,0x58,0x19,0xee,0xa5,0x75,0x17,0x22,0x2c,
	  0x50,0xad,0xd5,0x8b,0xa0,0x42,0xea,0x98,0x96,0xc0,0x01,0x0e,0xa5,0xdf,0x67,0x41,
	  0x9a,0x10,0x71,0x1b,0xd4,0xeb,0x4d,0xeb,0xe9,0xce,0xbe,0xc3,0x1e,0x35,0xcc,0x6e,
	  0x58,0xd9,0x3b,0xe3,0x52,0x88,0xbb,0x0e,0x04,0x02,0xbd,0x7c,0xfe,0xa5,0x6f,0xf5},
	  /*TST_OutputLen*/
	  128,
	  TST_KMNG_DO_NOT_VERIFY_OUTPUT,
	  /*TST_UserData*/
	  {0}
  },
  {
	  {"Imported 2048RSA PRIM key"},
	  /*TST_Pwd*/
	  {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	  /*TST_PwdLen*/
	  10,
	  /*TST_KeyPwd*/
	  {0x1,0x2,0x3,0x4},
	  /*TST_KeyPwdLen*/
	  4,
	  /*TST_KeyID*/
	  0,
	  /*TST_KeyType*/
	  KMNG_KeyTypeRSAPair,
	  /*TST_KeyUsage*/
	  KMNG_KEY_USAGE_SIGNING,
	  /*TST_KeyRestriction*/
	  KMNG_KEY_RESTRICTION_EXPORTABLE,
	  /*TST_KeySize*/
	  256,
	  /*TST_PKCS1_ver*/
	  CRYS_PKCS1_versionLast,
	  /*TST_HASHMode*/
	  CRYS_RSA_HASH_SHA1_mode,
	  /*TST_E*/
	  {0x01,0x00,0x01},
	  /*TST_ESize*/
	  3,
	  /*TST_ExportedE*/
	  {0},
	  /*TST_ExportedESize*/
	  0,    
	  /*TST_N*/
	  {0xb5,0x84,0x8f,0x09,0xa3,0x94,0xac,0x97,0x25,0x17,0x54,0x46,0x6c,0x49,0xcb,0x69,
	  0xff,0x21,0x68,0x03,0x1b,0xb9,0xf6,0xe8,0x14,0x84,0xa2,0xa5,0x62,0x39,0x8d,0xe4,
	  0x2f,0x22,0xc8,0x53,0xc0,0x8e,0x9a,0x5c,0x6f,0x2b,0xb2,0xa2,0x24,0x77,0x60,0xa1,
	  0x47,0xa5,0x6c,0xd5,0xe0,0x77,0x33,0x7a,0xd5,0xf5,0xf6,0x4a,0x0e,0x7d,0x06,0xbd,
	  0xb2,0x3b,0x83,0xef,0xaf,0xad,0x65,0xda,0xdb,0xd0,0x7d,0xea,0x09,0x73,0xf8,0x4e,
	  0x1b,0xe7,0xaa,0xe6,0x84,0x57,0xb6,0xf3,0x88,0xf3,0xb0,0x4d,0x2b,0xa9,0xe8,0x23,
	  0xa3,0xee,0x3f,0x16,0xd0,0x08,0x80,0x38,0x11,0x4a,0x66,0x3a,0xad,0x14,0x68,0xc4,
	  0x37,0xce,0x36,0x7a,0xf4,0xe0,0x95,0x0d,0xf3,0xae,0x2b,0x46,0xb7,0xac,0x4a,0x8a,
	  0xa0,0xe1,0x78,0xd1,0x38,0xa9,0x36,0xdb,0x3d,0xde,0x04,0xa2,0x35,0x79,0x1f,0xc5,
	  0x13,0x39,0xf8,0x5b,0xf3,0x5a,0xb5,0xcb,0xf9,0x8f,0x1c,0xf8,0xad,0x09,0x0f,0x03,
	  0x04,0xf3,0xcc,0x02,0x4c,0xa8,0x6d,0xe1,0x0a,0x3f,0x71,0x75,0x69,0xf4,0xd3,0xe6,
	  0xa8,0x2c,0x92,0x0b,0xb5,0x6d,0x7d,0xf9,0x61,0x68,0x42,0xd7,0xbe,0xde,0x32,0x9f,
	  0xfb,0x7a,0x23,0x2d,0xc5,0x22,0x3d,0x90,0xc3,0x38,0x12,0x5e,0xb0,0x9b,0xc0,0x5c,
	  0x7b,0x5d,0x4f,0x7a,0xec,0x65,0xb6,0xe1,0x24,0xfa,0x00,0x15,0xe3,0x5e,0x4f,0x80,
	  0x2e,0x79,0xe7,0x29,0xdc,0x4d,0xa2,0x15,0x68,0xe7,0x83,0xc9,0x40,0xfc,0x89,0xa9,
	  0x6a,0x47,0xff,0xbc,0x39,0x6d,0x0a,0x75,0xe1,0x6e,0x17,0x39,0x5f,0x1e,0x4f,0xdf},
	  /*TST_NSize*/
	  256,
	  /*TST_ExportedN*/
	  {0},
	  /*TST_ExportedNSize*/
	  0,    
	  /*TST_D*/
	  {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
	  0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
	  0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
	  0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
	  0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
	  0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
	  0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
	  0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
	  0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
	  0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
	  0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
	  0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
	  0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
	  0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
	  0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
	  0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
	  /*TST_DSize*/
	  256,
	  /*TST_ExportedD*/
	  {0},
	  /*TST_ExportedDSize*/
	  0,
	  /*TST_Data*/
	  {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
	  0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
	  0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
	  0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
	  0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
	  0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
	  0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
	  0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
	  0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
	  0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
	  0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
	  0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
	  0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
	  0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
	  0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
	  0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
	  /*TST_DataLen*/
	  256,
	  /*TST_ExpectedOutput*/
	  {0x9f,0x5c,0x50,0x40,0x5e,0xe3,0xcd,0x73,0xa8,0xfd,0x6e,0xc8,0x1b,0x10,0x48,0xc2,
	  0x31,0xc7,0xb5,0x3c,0xff,0x91,0x2f,0x1b,0xa3,0x33,0x7c,0x3c,0x18,0x06,0x17,0x47,
	  0x86,0xb0,0x88,0x3c,0x6a,0x65,0xb7,0xd2,0x9f,0x0d,0x89,0xbe,0x01,0xa2,0x2a,0x29,
	  0x00,0x91,0xe2,0xa4,0x48,0xd2,0x0f,0x9e,0xb4,0xb8,0xc5,0xcf,0x7f,0xb7,0xbd,0x32,
	  0xc9,0x9c,0x0b,0x34,0x9b,0x15,0x65,0x6d,0x93,0xf9,0x31,0x4e,0x71,0x23,0x3f,0xb8,
	  0xae,0xc4,0x6a,0xa9,0x2a,0x37,0xbb,0x60,0xaa,0x58,0x64,0xa1,0xbd,0xfd,0xa8,0x01,
	  0xb9,0x7c,0xd2,0x06,0x28,0xb5,0x85,0x31,0xff,0x08,0xd6,0xa4,0x52,0xa3,0x92,0xc4,
	  0xa6,0x3f,0xf4,0x9e,0xcf,0x18,0x54,0x8c,0x0a,0xa6,0x80,0xf6,0xc6,0x67,0x72,0xb9,
	  0x85,0x0b,0x82,0x83,0xc0,0x8b,0x1c,0xd3,0x62,0x55,0x7d,0xca,0x83,0x82,0x44,0x3d,
	  0xbb,0x47,0xbb,0x8d,0x5c,0x03,0x53,0xea,0xa1,0xe5,0x5a,0x96,0x9e,0xa9,0x8e,0xb2,
	  0x4f,0x3b,0x8e,0xcf,0x2e,0x31,0xb6,0x01,0xc7,0xff,0x4f,0x3f,0xc8,0xba,0xda,0x6b,
	  0xa1,0x0a,0xd7,0x66,0x9b,0x7b,0xd4,0x9c,0xce,0xb5,0xf5,0xeb,0x56,0x17,0x8d,0x30,
	  0x2f,0x14,0xbf,0xe0,0x99,0x23,0x7c,0x7f,0x42,0xe4,0x85,0x27,0x97,0x8b,0x16,0xc4,
	  0xa4,0x88,0x53,0x6c,0x33,0x1c,0x24,0x22,0xaf,0xf5,0xd1,0xe1,0xac,0x3b,0xab,0xe2,
	  0x23,0x7a,0xff,0xe0,0x68,0x47,0x8b,0x86,0x7e,0x71,0x2a,0x1c,0xbe,0x45,0x05,0x3d,
	  0x28,0x84,0x0c,0x50,0xab,0x05,0x72,0x27,0xc3,0xc6,0x0b,0xa7,0x3c,0xf9,0x1a,0x26},
	  /*TST_OutputLen*/
	  256,
	  TST_KMNG_VERIFY_OUTPUT,
	  /*TST_UserData*/
	  {0}
  },
  {
	  {"Created 2048RSA PRIM key"},
		  /*TST_Pwd*/
	  {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	  /*TST_PwdLen*/
	  10,
	  /*TST_KeyPwd*/
	  {0x1,0x2,0x3,0x4},
	  /*TST_KeyPwdLen*/
	  4,
	  /*TST_KeyID*/
	  0,
	  /*TST_KeyType*/
	  KMNG_KeyTypeRSAPair,
	  /*TST_KeyUsage*/
	  KMNG_KEY_USAGE_SIGNING,
	  /*TST_KeyRestriction*/
	  KMNG_KEY_RESTRICTION_EXPORTABLE,
	  /*TST_KeySize*/
	  256,
	  /*TST_PKCS1_ver*/
	  CRYS_PKCS1_versionLast,
	  /*TST_HASHMode*/
	  CRYS_RSA_HASH_SHA1_mode,
	  /*TST_E*/
	  {0x01,0x00,0x01},
	  /*TST_ESize*/
	  3,
	  /*TST_ExportedE*/
	  {0},
	  /*TST_ExportedESize*/
	  0,    
	  /*TST_N*/
	  {0},
	  /*TST_NSize*/
	  256,
	  /*TST_ExportedN*/
	  {0},
	  /*TST_ExportedNSize*/
	  0,    
	  /*TST_D*/
	  {0},
	  /*TST_DSize*/
	  256,
	  /*TST_ExportedD*/
	  {0},
	  /*TST_ExportedDSize*/
	  0,
	  /*TST_Data*/
	  {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
	  0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
	  0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
	  0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
	  0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
	  0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
	  0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
	  0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
	  0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
	  0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
	  0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
	  0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
	  0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
	  0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
	  0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
	  0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
	  /*TST_DataLen*/
	  256,
	  /*TST_ExpectedOutput*/
	  {0},
	  /*TST_OutputLen*/
	  256,
	  TST_KMNG_DO_NOT_VERIFY_OUTPUT,
	  /*TST_UserData*/
	  {0}
	}
};


TST_KeysRSAHASHData_TestDataStruct TST_KeysOpRSAHASHData_TestData[] = 
{
  {
    /*TST_MD5Data*/
    {0xd4,0x22,0x19,0x30,0x15,0x2a,0xa2,0x54,0x81,0xc7,0x5f,0x9a,0xf8,0xce,0x9a,0x45},
    /*TST_SHA1Data*/
    {0xe4,0x8e,0xbf,0x67,0xe0,0xa0,0x2a,0xfe,0x14,0x71,0x60,0x6f,0x8f,0x4d,0xd4,0xee,
     0x16,0xf4,0xfe,0x7f},
    /*TST_SHA224Data*/
    {0x28,0x42,0x5d,0x60,0xbf,0xea,0xd8,0x24,0x86,0x38,0x82,0x06,0x5a,0x79,0xfc,0x2e,
     0x75,0xe0,0xc6,0xd8,0x47,0xf8,0x88,0xac,0x3d,0xb4,0x0f,0x5f},
    /*TST_SHA256Data*/ 
    {0x48,0x6d,0x45,0x40,0xd9,0x12,0xe6,0x0a,0x4d,0xd9,0x2d,0xb8,0x09,0xe5,0x01,0xce,
     0x54,0x67,0xac,0x24,0xca,0xad,0x15,0x09,0xf1,0x49,0x4b,0x36,0x07,0xdc,0xe4,0x3b},
    /*TST_SHA384Data*/
    {0x1b,0x10,0xf2,0x2a,0x31,0x9d,0xb2,0xd0,0x0a,0xd2,0x9d,0xd0,0x77,0xe0,0x42,0x44,
     0xda,0x5b,0x7b,0x97,0x4d,0x8c,0xfe,0x14,0xdc,0x20,0x8e,0xe6,0x12,0xa7,0x1a,0x5f,
     0x43,0x43,0xaf,0xf2,0x64,0xb9,0xa0,0xc8,0x06,0xd1,0xaf,0xda,0xff,0x7b,0xe0,0x68},
    /*TST_SHA512Data*/
    {0x07,0x4e,0xb7,0xf6,0x40,0x79,0x15,0x5c,0xd5,0xc5,0x81,0xb3,0xdf,0x81,0x24,0x1b,
     0x51,0x9b,0x95,0xf7,0xb0,0x5c,0xd6,0xaa,0xe8,0x07,0xf1,0x78,0x38,0xdd,0x89,0xf3,
     0x6d,0x1f,0xaa,0x65,0x5d,0x7f,0x03,0x4b,0x6d,0x19,0xfa,0x33,0xe5,0xa7,0x46,0x4e,
     0x44,0x3b,0x53,0xd6,0x4f,0x24,0xb3,0xbf,0xed,0xf3,0x94,0x3f,0x7e,0xbe,0xa8,0x41}, 
  }
};

/* Data for the DH tests */
TST_KeysDHData_TestDataStruct TST_KeysDHData_TestData[] = 
{
    {
	    /*TST_Name */
	    {"Created 1024Bits DH key"},
	    /*TST_Pwd*/
	    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	    /*TST_PwdLen*/
	    10,
	    /*TST_KeyPwd*/
	    {0x1,0x2,0x3,0x4},
	    /*TST_KeyPwdLen*/
	    4,
	    /*TST_KeyID*/
	    0,
	    /*TST_KeyType*/
	    KMNG_KeyTypeDH,
	    /*TST_KeyUsage*/
	    KMNG_KEY_USAGE_LEGACY,
	    /*TST_KeyRestriction*/
	    KMNG_KEY_RESTRICTION_EXPORTABLE,
	    /*TST_KeySize*/
	    128,
	    /*TST_P */
	    {0},
	    /*TST_PSize */
	    128,
	    /*TST_ExportedP */
	    {0},
	    /*TST_ExportedPSize */
	    0,
	    /*TST_G */
	    {0},
        /*TST_GSize */
	    128,
	    /*TST_ExportedG */
	    {0},
	    /*TST_ExportedGSize */
	    0,
	    /*TST_PubKey */
	    {0},
	    /*TST_PubKeySize */
	    0,
	    /*TST_ExportedPubKey */
	    {0},
	    /*TST_ExportedPubKeySize */
	    0,
	    /*TST_PrivateKey */
	    {0},
	    /*TST_PrivateKeySize */
	    0,
	    /*TST_ExportedPrivateKey */
	    {0},
	    /*TST_ExportedPrivateKeySize */
	    0,
	    /*TST_L */
	    11,
	    /*TST_SecretKey */
	    {0},
	    /*TST_ServerSecretKey */
	    {0},
	    /*TST_VerifyOutput */
	    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
	    /*TST_UserData */
	    {0}
    },
    {
	    /*TST_Name */
	    {"Imported 1024Bits DH key"},
	    /*TST_Pwd*/
	    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
	    /*TST_PwdLen*/
	    10,
	    /*TST_KeyPwd*/
	    {0x1,0x2,0x3,0x4},
	    /*TST_KeyPwdLen*/
	    4,
	    /*TST_KeyID*/
	    0,
	    /*TST_KeyType*/
	    KMNG_KeyTypeDH,
	    /*TST_KeyUsage*/
	    KMNG_KEY_USAGE_LEGACY,
	    /*TST_KeyRestriction*/
	    KMNG_KEY_RESTRICTION_EXPORTABLE,
	    /*TST_KeySize*/
	    128,
	    /*TST_P */
      {0xC4,0xAC,0x0A,0xD9,0x6A,0xF5,0xB1,0x93,0x46,0x43,0xAC,0x5B,0x2E,0x45,0x38,0x29,
      0x4E,0x24,0xDE,0x8F,0x80,0x28,0x6C,0x4A,0xEF,0xCB,0xC2,0x07,0xE5,0xAE,0xEC,0x4F,
      0x9A,0x1B,0x1B,0x61,0x35,0xDB,0xF9,0x88,0x83,0x61,0x4E,0xCA,0x8E,0x82,0x43,0xF9,
      0x56,0x9F,0x4C,0xB0,0x28,0xBC,0xA9,0x9A,0x23,0x05,0xBD,0x08,0x7D,0xC6,0x3B,0x62,
      0x8F,0x2A,0x96,0x30,0xCF,0x29,0x6F,0x1C,0x18,0x54,0x57,0x9F,0xCB,0xF3,0xB0,0x85,
      0xB9,0xCE,0xEA,0xCE,0x71,0x7A,0x16,0x05,0xB3,0xEB,0xF4,0xF6,0x99,0xD2,0x7C,0xE8,
      0x0E,0x36,0x01,0x3F,0x87,0x6C,0x4A,0xFC,0x45,0x67,0x09,0x5C,0xCB,0x09,0x9A,0x5B,
      0x96,0x61,0xD3,0x35,0x1A,0x04,0x07,0xA8,0x68,0xE4,0xC4,0xB1,0x3B,0x11,0xD7,0xA3},
	    /*TST_PSize */
	    128,
	    /*TST_ExportedP */
	    {0},
	    /*TST_ExportedPSize */
	    0,
	    /*TST_G */
      {0xC4,0x3B,0x36,0xC8,0xE7,0xA9,0x60,0xEA,0x35,0x80,0x6A,0x02,0x6A,0x02,0x02,0xCB,
      0x21,0x24,0x3D,0xB8,0x3D,0x01,0x76,0x63,0x8A,0xEE,0x95,0x50,0x94,0x1D,0x6F,0x0C,
      0x6F,0x84,0x17,0x16,0x24,0x00,0x27,0xE2,0x01,0x8A,0xA8,0xA4,0xDF,0x7E,0xDE,0xB4,
      0x49,0x20,0x2C,0x8F,0x34,0x3B,0xA1,0x4E,0x6B,0x02,0x23,0x11,0x42,0x9A,0x9C,0xBA,
      0x22,0x15,0x06,0x1C,0x26,0x39,0x1C,0xDB,0x43,0xD3,0x2C,0x75,0x96,0xAF,0x97,0xCF,
      0xA9,0x32,0xA1,0xA7,0x3F,0x90,0xA9,0xA8,0x1D,0xB8,0x48,0xCC,0x2E,0x68,0xC1,0xF1,
      0x71,0xD2,0xFB,0x4F,0xDA,0x9C,0x89,0x02,0xEA,0x89,0x9B,0xA2,0xE9,0x33,0xC4,0xFE,
      0x7A,0x31,0x39,0x71,0x12,0x18,0xB9,0xBE,0x33,0x10,0xCF,0x1B,0x65,0xCB,0xC1,0x73},
	    /*TST_GSize */
	    128,
	    /*TST_ExportedG */
	    {0},
	    /*TST_ExportedGSize */
	    0,
	    /*TST_PubKey */
      {0x1F,0xCE,0x27,0xC9,0xC1,0x99,0xF7,0xC0,0x92,0x71,0xA3,0x60,0x5C,0x1C,0xA6,0x9E,
      0x4E,0x8F,0x48,0xDC,0x2E,0xD8,0xBE,0x76,0x8D,0x1C,0x5A,0x0C,0x1D,0xF3,0x4C,0xB8,
      0x4B,0x79,0xE4,0xBF,0x49,0x6B,0x13,0xCE,0x88,0x0A,0x17,0x89,0x1F,0x14,0x6A,0x43,
      0x74,0xBF,0xA0,0x8F,0xD4,0x1F,0xCC,0xF8,0x7A,0xFD,0xAB,0xC4,0x5B,0x62,0xD0,0x71,
      0x21,0x5F,0x1E,0xA1,0x2E,0x4F,0x92,0x3E,0x6F,0x59,0x37,0xE9,0x2F,0x3F,0x36,0xE8,
      0x65,0x87,0x22,0x77,0x21,0xE9,0x1C,0x5C,0x9A,0xDA,0x24,0x2F,0x90,0x66,0xF3,0x7E,
      0xBD,0x8B,0xF1,0x12,0xCC,0x5A,0x60,0x21,0x06,0xF6,0xCC,0xCB,0x95,0x36,0xB3,0x65,
      0xC5,0x40,0x46,0x22,0x5B,0xEF,0x63,0xB3,0x35,0x86,0x39,0xB8,0x32,0x5A,0x41,0x5D},
	    /*TST_PubKeySize */
	    128,
	    /*TST_ExportedPubKey */
	    {0},
	    /*TST_ExportedPubKeySize */
	    0,
	    /*TST_PrivateKey */
      {0x58,0xB6,0x3B,0x27,0x04,0x9B,0xAC,0xE2,0xFA,0x24,0x69,0xB8,0x71,0x31,0xE3,0xF9,
      0xF4,0x72,0x75,0x55,0x6E,0x74,0x1B,0xEA,0x86,0x56,0xDB,0xEC,0xC6,0x30,0x6C,0xFD,
      0x7F,0x4E,0x28,0x6F,0x9C,0xA7,0x7C,0x35,0xAB,0x24,0xA7,0xF2,0x17,0x7F,0xCE,0xE9,
      0x26,0x9F,0x6F,0x66,0x4D,0x32,0x8C,0x1F,0x5B,0x8F,0x9C,0xC6,0x11,0xE2,0xDC,0x7D,
      0x03,0xA2,0x03,0x50,0x6E,0x32,0x86,0x2D,0x6D,0xC5,0x47,0x09,0x07,0xF6,0xA2,0x02,
      0xC7,0x9D,0xBE,0xB5,0xFF,0x01,0xF6,0xAD,0xA4,0x4B,0x86,0xC1,0x60,0x57,0x02,0xBE,
      0x83,0x25,0x31,0x8D,0x25,0x94,0x85,0x23,0x99,0xDF,0x82,0x30,0x1D,0xDD,0xE7,0x34,
      0xBF,0x2E,0x03,0xAB,0x36,0xEC,0x1C,0x8C,0x34,0x2A,0x9F,0x9D,0xF9,0xF8,0x49,0xB4},
	    /*TST_PrivateKeySize */
	    128,
	    /*TST_ExportedPrivateKey */
	    {0},
	    /*TST_ExportedPrivateKeySize */
	    0,
	    /*TST_L */
	    0,
	    /*TST_SecretKey */
	    {0},
	    /*TST_ServerSecretKey */
	    {0},
	    /*TST_VerifyOutput */
	    TST_KMNG_VERIFY_OUTPUT,
	    /*TST_UserData */
	    {0}
    },
    {
        /*TST_Name */
        {"created 2048Bits DH key"},
        /*TST_Pwd*/
        {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
        /*TST_PwdLen*/
        10,
        /*TST_KeyPwd*/
        {0x1,0x2,0x3,0x4},
        /*TST_KeyPwdLen*/
        4,
        /*TST_KeyID*/
        0,
        /*TST_KeyType*/
        KMNG_KeyTypeDH,
        /*TST_KeyUsage*/
        KMNG_KEY_USAGE_LEGACY,
        /*TST_KeyRestriction*/
        KMNG_KEY_RESTRICTION_EXPORTABLE,
        /*TST_KeySize*/
        256,
        /*TST_P */
        {0},
        /*TST_PSize */
        256,
        /*TST_ExportedP */
        {0},
        /*TST_ExportedPSize */
        0,
        /*TST_G */
        {0},
        /*TST_GSize */
        256,
        /*TST_ExportedG */
        {0},
        /*TST_ExportedGSize */
        0,
        /*TST_PubKey */
        {0},
        /*TST_PubKeySize */
        0,
        /*TST_ExportedPubKey */
        {0},
        /*TST_ExportedPubKeySize */
        0,
        /*TST_PrivateKey */
        {0},
        /*TST_PrivateKeySize */
        0,
        /*TST_ExportedPrivateKey */
        {0},
        /*TST_ExportedPrivateKeySize */
        0,
        /*TST_L */
        12,
        /*TST_SecretKey */
        {0},
        /*TST_ServerSecretKey */
        {0},
        /*TST_VerifyOutput */
        TST_KMNG_DO_NOT_VERIFY_OUTPUT,
        /*TST_UserData */
        {0}
    },
    {
        /*TST_Name */
        {"imported 2048Bits DH key"},
        /*TST_Pwd*/
        {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
        /*TST_PwdLen*/
        10,
        /*TST_KeyPwd*/
        {0x1,0x2,0x3,0x4},
        /*TST_KeyPwdLen*/
        4,
        /*TST_KeyID*/
        0,
        /*TST_KeyType*/
        KMNG_KeyTypeDH,
        /*TST_KeyUsage*/
        KMNG_KEY_USAGE_LEGACY,
        /*TST_KeyRestriction*/
        KMNG_KEY_RESTRICTION_EXPORTABLE,
        /*TST_KeySize*/
        256,
        /*TST_P */
        {0xce,0xd3,0x02,0x09,0x7d,0xe5,0x34,0xf5,0x3f,0x14,0x2e,0x7b,0x3e,0x15,0x4c,0x66,
        0x2c,0xe1,0xf0,0xb7,0x40,0x72,0x68,0xfa,0xad,0xa6,0xd5,0xd9,0x55,0x1e,0x7e,0xfd,
        0x06,0xbc,0x4f,0xb8,0x27,0xe9,0x22,0x3d,0x17,0xfa,0x4d,0x8c,0x8b,0x8e,0xce,0xf6,
        0xc9,0x49,0x38,0x74,0xa2,0x77,0x3b,0x9a,0xe1,0xc0,0xa7,0xc8,0x83,0xf9,0xdc,0xa7,
        0x9a,0x12,0xc5,0x19,0x5c,0xfb,0x40,0x0c,0x08,0x57,0xa1,0xf7,0x8d,0xf2,0x10,0x83,
        0xe8,0xe7,0x8a,0xc1,0x0c,0x59,0xa1,0xa3,0x77,0xb1,0x9f,0x0d,0x0f,0xf8,0x27,0xdd,
        0xdc,0xed,0xbf,0x04,0x91,0xa3,0x00,0x19,0x08,0x2d,0x7c,0xc9,0xda,0xfb,0x05,0x31,
        0xf5,0x34,0x0d,0xaa,0xd3,0xbb,0xc0,0x5b,0xfb,0xad,0x32,0x6b,0x98,0x00,0x17,0x01,
        0x39,0x61,0x0e,0x03,0x2e,0xf6,0x60,0x30,0x7b,0xb9,0xeb,0x39,0x60,0x1b,0xc4,0x7f,
        0xe5,0xcb,0x5f,0xc3,0xb0,0x79,0xdb,0x04,0xd2,0x9a,0x11,0x95,0x3e,0xa4,0x33,0x61,
        0x8e,0x94,0x22,0x9b,0x0a,0xd0,0xfb,0xda,0x07,0xc7,0x34,0xfb,0xa9,0x94,0xc8,0x31,
        0x03,0xe1,0x92,0xac,0x86,0xfc,0x45,0xe3,0x79,0x0b,0x9e,0x29,0x63,0xe8,0xcf,0x26,
        0x05,0xb3,0x6e,0xa9,0xae,0x9d,0xe3,0xdc,0x03,0x43,0x26,0xdf,0x7e,0x8b,0xae,0xcb,
        0xe8,0x09,0x04,0x25,0xdd,0x42,0xb8,0x59,0x44,0xec,0xc1,0xc7,0xbf,0x78,0x50,0x31,
        0xec,0x6e,0xa5,0x5f,0xe4,0x4f,0x79,0x7b,0xf3,0xbf,0x03,0xd3,0xa9,0x7b,0x7c,0x70,
        0xa2,0x5f,0xdb,0x86,0x96,0xfa,0xd1,0x3f,0x43,0xc5,0xd2,0x2a,0xf8,0xf3,0x3c,0x7b},
        /*TST_PSize */
        256,
        /*TST_ExportedP */
        {0},
        /*TST_ExportedPSize */
        0,
        /*TST_G */
        {0xc9,0x16,0xa6,0x54,0x91,0xa7,0x1c,0xdf,0x9b,0xf9,0x59,0x07,0x95,0x06,0x4f,0xfa,
        0x95,0x79,0xc5,0x20,0x47,0xa4,0x75,0xce,0x49,0xb5,0x3c,0xfa,0x91,0xd4,0xd2,0xb5,
        0xe5,0x6b,0x36,0x24,0x5f,0x90,0x8e,0xfb,0x7a,0x1b,0x41,0xf7,0x18,0x41,0xfc,0x7b,
        0xa5,0xb4,0xc3,0xe1,0x71,0xb4,0x66,0x54,0x02,0x0a,0xd3,0xd9,0xd2,0x9d,0xe6,0x18,
        0x6d,0x2a,0xb7,0xdb,0x45,0xbe,0xc1,0x83,0x7f,0x94,0x5b,0xd7,0xd8,0x98,0xd2,0xcf,
        0x54,0x38,0x39,0xda,0x90,0x86,0xcc,0xab,0x0f,0x15,0xf8,0xb8,0xbf,0xde,0x50,0x07,
        0x74,0x45,0x84,0x4c,0x2f,0x08,0xb1,0x2f,0x40,0x49,0x9c,0xaf,0xb6,0xd1,0x6c,0xe3,
        0x45,0xbf,0xf1,0x63,0xcc,0x77,0x66,0x5d,0x45,0x35,0xb9,0x0a,0xac,0x74,0x14,0x91,
        0x64,0x1b,0x34,0x50,0xb4,0xa0,0x1e,0xd9,0xa9,0x62,0x56,0x57,0xcb,0x73,0x3c,0x96,
        0x5f,0x86,0x7f,0xc3,0x66,0xbf,0xac,0x79,0x21,0x51,0x14,0x3f,0x37,0x29,0xbe,0x96,
        0xc8,0xee,0xf1,0xaf,0x4e,0xc7,0x9f,0x83,0x20,0xe7,0xb5,0xb2,0x52,0x57,0xcc,0xa8,
        0xb0,0xf2,0x4d,0x88,0x3e,0x71,0xfb,0xd7,0x45,0x4d,0x96,0x0b,0xcb,0x24,0x0a,0x88,
        0x4f,0xaf,0xe8,0x96,0x79,0x87,0x14,0xf8,0x1e,0x3d,0xf7,0x2c,0x48,0xf7,0x0e,0x52,
        0x4e,0x3d,0xcb,0xeb,0x57,0x54,0xb9,0x90,0xe1,0x14,0x5c,0x36,0x7d,0xc0,0xa3,0x5f,
        0xf4,0xfd,0xf6,0x33,0x23,0x7e,0xf2,0xd0,0xff,0x0d,0xe0,0xe2,0xa3,0xcc,0x81,0x86,
        0xbc,0xde,0x67,0x83,0x03,0xd6,0xfa,0x5b,0x42,0xd3,0x1f,0xfe,0xd2,0x0f,0x2b,0x1b},
        /*TST_GSize */
        256,
        /*TST_ExportedG */
        {0},
        /*TST_ExportedGSize */
        0,
        /*TST_PubKey */
        {0x4C,0xE5,0xDD,0x89,0x95,0x7C,0x84,0xA6,0x65,0xA0,0x56,0x21,0xC5,0xA8,0x13,0xBE,
        0x51,0x5C,0x97,0x2B,0xA8,0x3A,0xF2,0x33,0x26,0x64,0x79,0x13,0x5C,0x14,0x8D,0xFA,
        0x7F,0x2B,0x75,0x10,0x24,0xB7,0xDE,0xC2,0x71,0x75,0xE2,0x40,0x86,0x06,0x1A,0x77,
        0xD6,0x9F,0xF0,0x1D,0xD8,0x5D,0xD8,0x39,0x19,0xC8,0x69,0x28,0xF9,0x0B,0x28,0x7B,
        0xD0,0x6F,0xD5,0x7B,0xDE,0x26,0x20,0x9C,0x86,0x31,0x3F,0x50,0xFE,0x67,0xD3,0x78,
        0xF6,0xC8,0x68,0xE3,0xA6,0x11,0xDB,0xD2,0xE4,0xA0,0xF9,0x2C,0x3E,0x85,0x9B,0x31,
        0x99,0xB0,0x23,0xC7,0x63,0x0A,0xF8,0x96,0x1F,0x60,0xB3,0x85,0x3E,0x2D,0x81,0x57,
        0xFC,0x99,0xD7,0x2E,0x5F,0xA5,0xB4,0xF0,0x90,0x04,0x96,0xFD,0xF5,0x31,0x94,0x9E,
        0x31,0xD1,0xE7,0xFD,0x0A,0x70,0x33,0x8C,0x8A,0x9E,0xC8,0xFD,0x71,0x30,0x30,0xBF,
        0x0C,0x6C,0x63,0x07,0x3C,0x37,0xD4,0xAD,0xA7,0x82,0x6C,0x10,0x50,0xE6,0x5F,0xD8,
        0xA0,0x34,0x8A,0x7E,0xFC,0xA1,0x6A,0x57,0xEC,0x37,0x2E,0x3A,0x21,0x31,0x94,0x86,
        0x4F,0x5C,0x50,0x17,0xFA,0x80,0x67,0xB9,0xD9,0x33,0x1A,0xAF,0xD0,0x05,0x26,0xF5,
        0xEE,0x4B,0x1C,0x29,0xDD,0x50,0x59,0xF7,0x66,0xEC,0x3A,0x92,0x0A,0xBD,0xF2,0xC5,
        0x05,0xFC,0x54,0x29,0xC6,0x36,0xFE,0xEF,0x0E,0x99,0xFD,0x03,0x84,0x99,0x36,0x7C,
        0xBB,0x3A,0x50,0xD9,0x1E,0xFE,0x35,0x44,0x82,0xCD,0x52,0xB7,0xC9,0x1E,0x81,0xBC,
        0x4D,0xB1,0xD6,0x84,0x61,0x05,0xCC,0x8C,0xCB,0xA2,0x42,0x97,0xC4,0x0E,0x67,0x45},
        /*TST_PubKeySize */
        256,
        /*TST_ExportedPubKey */
        {0},
        /*TST_ExportedPubKeySize */
        0,
        /*TST_PrivateKey */
        {0x23,0x96,0x30,0xD2,0x6A,0x73,0xD7,0x29,0xA2,0x65,0x23,0x23,0x05,0x62,0x42,0xE7,
        0xE6,0x29,0xD7,0x3C,0x9A,0xD9,0xFE,0x4D,0x31,0x5B,0xE1,0xA6,0x68,0xFD,0x9B,0x1F,
        0xB5,0xF8,0xB8,0xF2,0x72,0x0A,0xD3,0xCB,0x82,0x7A,0xEC,0x24,0x37,0x15,0xF0,0x8C,
        0x10,0xEB,0xD7,0x48,0x9B,0xE4,0x4D,0x09,0xCB,0x20,0xC4,0x79,0x0B,0x28,0x2D,0x14,
        0xFC,0xCD,0x50,0xCB,0xEB,0xDE,0xB6,0x63,0xA2,0x0C,0xA5,0x30,0x89,0x0E,0x4D,0xF9,
        0x33,0xA1,0xFA,0x68,0xE4,0xCF,0xCD,0xE7,0x22,0xA5,0xCF,0xFD,0xD1,0x68,0x3A,0xCB,
        0xB4,0x64,0x87,0x22,0x2E,0x54,0x35,0x90,0xF7,0xEF,0x62,0xC3,0xBD,0xC4,0x43,0xA4,
        0x63,0xB1,0xC5,0xEC,0x64,0x9E,0x5A,0x48,0xC0,0x21,0x6E,0x05,0x43,0xFD,0xCC,0x64,
        0xEE,0x17,0x21,0x7A,0x70,0xFE,0x24,0xF5,0xDB,0x44,0xB4,0x58,0x33,0xD8,0xD6,0x58,
        0xB4,0xF4,0x16,0x5E,0xDE,0x8C,0x81,0x1D,0x39,0x6D,0xB1,0xC4,0x61,0x31,0x38,0xA4,
        0xAD,0x65,0xDD,0xED,0x6C,0x8A,0x94,0xD4,0x3C,0x6D,0xC0,0x2C,0xF6,0x20,0xD8,0xC9,
        0x29,0x82,0x24,0x13,0x5F,0x4B,0x21,0xAB,0x0F,0x91,0x59,0xC2,0x5D,0xA9,0x43,0xD4,
        0x03,0x2E,0xB0,0xD2,0x48,0xA1,0x70,0x39,0x26,0xF9,0xAC,0xC1,0x46,0x50,0x92,0x00,
        0x46,0xE4,0x9A,0x2F,0x1B,0x90,0x92,0xE7,0x65,0x22,0xEA,0xAE,0xB4,0xC2,0x12,0xCD,
        0xF3,0x20,0xF2,0x84,0x7A,0x3F,0x35,0xCE,0x80,0x32,0x31,0xA7,0x79,0x58,0x01,0x98,
        0x54,0x62,0x87,0xE6,0x85,0xC3,0xF0,0x47,0x7C,0xB1,0x16,0x80,0xE6,0xE5,0x60,0x88},
        /*TST_PrivateKeySize */
        256,
        /*TST_ExportedPrivateKey */
        {0},
        /*TST_ExportedPrivateKeySize */
        0,
        /*TST_L */
        0,
        /*TST_SecretKey */
        {0},
        /*TST_ServerSecretKey */
        {0},
        /*TST_VerifyOutput */
        TST_KMNG_VERIFY_OUTPUT,
        /*TST_UserData */
        {0}
    }
};     

const DxUint32_t TST_NumOf_SymKeysOpTests = sizeof(TST_KeysOpSym_TestData)/sizeof(TST_KeysOpSym_TestData[0]);
const DxUint32_t TST_NumOf_RSAKeysOpTests = sizeof(TST_KeysOpRSA_TestData)/sizeof(TST_KeysOpRSA_TestData[0]);
const DxUint32_t TST_NumOf_DHKeysTests = sizeof(TST_KeysDHData_TestData)/sizeof(TST_KeysDHData_TestData[0]);
/************* Private function prototype ***********************/
/************************ Public Functions ******************************/
